<?php

// Este archivo lo utilizaremos en posteriores líneas de código.
require "crawl-redirect.php";

# Recibimos la URL del Ajax realizado en GTM por POST.
$urlDeGTM = $_POST['url_analizar'];

# Reogemos el User Agent de la petición a la URL.
$userAgentURL = $_SERVER['HTTP_USER_AGENT'];


# Codificamos los valores para que se puedan implementar en la URL de la API.
$urlAPI = urlencode($urlDeGTM);
$userAgentAPI = urlencode($userAgentURL);

# Utilizaremos un servicio externo para extraer los valores que nos interesan.
# A la petición externa, añadimos la URL y el User Agent codificado anteriormente.
$url = "https://api.redirect-checker.net/?url=".$urlAPI."&timeout=5&maxhops=10&useragent=".$userAgentAPI."&meta-refresh=1&format=xml&more=1";

# Con esta función de PHP, conseguimos transformar el XML de respuesta de la API como un objeto.
# Una vez transformado en un objetivo, iremos obteniendo los valores que nos interesan.
$xml = simplexml_load_file($url);

# Puerto
# Si el puerto no es 443, no tendrá HTTPS. Habrá excepciones, pero de manera predeterminada, este será el puerto si la web tiene HTTPS activado.
$puerto = (string) $xml->data->session[0]->response->info->primary_port;

# Protocolo
# Con esta variable obtendremos el protocolo (HTTP o HTTPS). Complementaremos la información anterior.
$protocolo = (string) $xml->data->session[0]->response->info->url_parsed->scheme;

# Estatus URL
# Aquí obtendremos la respuesta que retorna la URL: 200, 301, 302, 307, 404, 500...
# En función de este valor (si es una respuesta diferente a 200) enviaremos más información a Google Analytics.
$estatus_url = (string) $xml->data->session[0]->response->info->http_code;

# Redirect URL
# Si la URL ha retornado algún valor de redirección (30X), recogeremos la URL final.
$redirect_url = (string) $xml->data->session[0]->response->info->redirect_url;

# User Agent
# Para tener información adicional, recogeremos también el User Agent que ha realizado la petición a la URL.
$user_agent = (string) $xml->data->session[0]->request->info->curl->CURLOPT_USERAGENT;

// Aquí ejecutamos la función getRedirectsToUrl() que se encuentra en el archivo requerido en las primeras líneas del código.
// Esta función detecta cuantas redirecciones se han producido y el tipo de redirección:
// - Redirección de servidor: 301, 302, 303 o 307
// - Meta refresh
// - Redirección de JavaScript
// - Redirección sin identificar
$redirects_info = getRedirectsToUrl($urlDeGTM);

# En este apartado enviaremos los datos a Google Analytics para, posteriormente, visualizarlos
# en Google Data Studio. Para enviar los datos a Google Analytics utilizaremos el protocolo de medición.

# Función para generar un User ID
function gen_uuid() {
	return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
	mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),
	mt_rand( 0, 0xffff ),
	mt_rand( 0, 0x0fff ) | 0x4000,
	mt_rand( 0, 0x3fff ) | 0x8000,
	mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
	);
}


# Aquí construimos un Array con los datos que enviaremos a Google Analytics.
# Para tener los datos localziados en Google Analytics, utilizaremos eventos.
# Podremos identificar estos eventos con la categoría "Seguimiento Migración" (si decidimos poner el mismo UA que hay implementado en la web)
$data = array(
'v' => 1,
'tid' => 'UA-12345678-1', // Cambiar este UA por vuestro código de seguimiento.
'cid' => gen_uuid(),
't' => 'event',
'ec' => 'Seguimiento Migración',
'ea' => $urlDeGTM,
'el' => $puerto.'_'.$protocolo.'_'.$estatus_url.'_'.$redirect_url.'_'.$redirects_info['redirects_count'].'_'.$redirects_info['redirects_code']
);

# Con estas dos variables construimos la llamada al protocolo de medición de Google Analytics.
$urlProtocoloMedicion = 'http://www.google-analytics.com/collect';
$contenidoProtocoloMedicion = http_build_query($data);

// Imprimimos los valores para poder comprobarlos en el debug de nuestro navegador
// Pestaña "Network" archivo "curl_charla.php"

echo('Data GTM: '.print_r($data, true).PHP_EOL);
echo('Data Medicion: '.print_r($contenidoProtocoloMedicion, true).PHP_EOL);


# Aquí construimos la llamada al protocolo de medición con CURL.
# CURL es una librería que permite realizar peticiones HTTP (emular el comportamiento de un navegador web).
# En esta llamada enviaremos datos a Google Analytics con las variables anteriormente descritas
$ch = curl_init();
curl_setopt($ch, CURLOPT_USERAGENT, 'useragent');
curl_setopt($ch, CURLOPT_URL, $urlProtocoloMedicion);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT_MS, 0);
curl_setopt($ch, CURLOPT_TIMEOUT_MS, 0);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-type: application/x-www-form-urlencoded'));
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch,CURLOPT_ENCODING , "gzip");
curl_setopt($ch, CURLOPT_POSTFIELDS, $contenidoProtocoloMedicion);

// Comprobamos si el CURL ha funcionado correctamente.
// Si el CURL ha fallado, enviaremos un KO. Si ha funcionado correctamente, enviaremos OK.
if (curl_exec($ch) === false) {
    echo "KO";
} else {
    echo "OK";
}
curl_close($ch);

?>